<?php

class ControllerExtensionPaymentGlofpayopencartpaymentaddon extends Controller 
{
	private $error = array();

	/**
	 * Process data of payment extensions after submit the form
	 *
	 * @param all request field
	 *
	 * @return save data to config
	 */
	public function index() 
	{
		$this->load->language('extension/payment/glofpayopencartpaymentaddon');
		$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('setting/setting');
		
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_setting_setting->editSetting('payment_glofpayopencartpaymentaddon', $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$this->response->redirect($this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment', true));
		}

		$data['error_warning'] = $this->error['warning'] ?? '';
		$data['error_merchant_client_id'] = $this->error['error_merchant_client_id'] ?? '';
        $data['error_merchant_secret_key'] = $this->error['error_merchant_secret_key'] ?? '';

		$data['breadcrumbs'] = [];

		$data['breadcrumbs'][] = [
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        ];

		$data['breadcrumbs'][] = [
			'text' => $this->language->get('text_extension'),
			'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment', true)
		];

		$data['breadcrumbs'][] = [
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('extension/payment/glofpayopencartpaymentaddon', 'user_token=' . $this->session->data['user_token'], true)
        ];

		$data['action'] = $this->url->link('extension/payment/glofpayopencartpaymentaddon', 'user_token=' . $this->session->data['user_token'], true);

		$data['cancel'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment', true);

        $data['payment_glofpayopencartpaymentaddon_merchant_client_id'] = $this->request->post['payment_glofpayopencartpaymentaddon_merchant_client_id'] ?? $this->config->get('payment_glofpayopencartpaymentaddon_merchant_client_id');

        $data['payment_glofpayopencartpaymentaddon_merchant_secret_key'] = $this->request->post['payment_glofpayopencartpaymentaddon_merchant_secret_key'] ?? $this->config->get('payment_glofpayopencartpaymentaddon_merchant_secret_key');

        $data['payment_glofpayopencartpaymentaddon_order_status_id'] = $this->request->post['payment_glofpayopencartpaymentaddon_order_status_id'] ?? $this->config->get('payment_glofpayopencartpaymentaddon_order_status_id');
		
		$this->load->model('localisation/order_status');

		$data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

        $data['payment_glofpayopencartpaymentaddon_geo_zone_id'] = $this->request->post['payment_glofpayopencartpaymentaddon_geo_zone_id'] ?? $this->config->get('payment_glofpayopencartpaymentaddon_geo_zone_id');

		$this->load->model('localisation/geo_zone');

		$data['geo_zones'] = $this->model_localisation_geo_zone->getGeoZones();

        $data['payment_glofpayopencartpaymentaddon_status'] = $this->request->post['payment_glofpayopencartpaymentaddon_status'] ?? $this->config->get('payment_glofpayopencartpaymentaddon_status');

        $data['payment_glofpayopencartpaymentaddon_sort_order'] = $this->request->post['payment_glofpayopencartpaymentaddon_sort_order'] ?? $this->config->get('payment_glofpayopencartpaymentaddon_sort_order');

		$data['header']      = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer']      = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('extension/payment/glofpayopencartpaymentaddon', $data));
	}

	/**
	 * Validate required field of payment extensions form
	 *
	 * @param required fields
	 *
	 * @return true/false
	 */

	private function validate() 
	{
		if (!$this->user->hasPermission('modify', 'extension/payment/glofpayopencartpaymentaddon')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if (!$this->request->post['payment_glofpayopencartpaymentaddon_merchant_client_id']) {
			$this->error['error_merchant_client_id'] = $this->language->get('error_merchant_client_id');
		}

		if (!$this->request->post['payment_glofpayopencartpaymentaddon_merchant_secret_key']) {
			$this->error['error_merchant_secret_key'] = $this->language->get('error_merchant_secret_key');
		}

		return !$this->error;
	}
}