<?php

require 'vendor/autoload.php';

// If you want to change the namespace/path from 'GLOFPAY' - lines[1-5] - to your desired name, i.e. (use GLOFPAY\Api\Amount; to use MyDomain\Api\Amount;), then you must change the folder names that hold the API classes as well as change the property 'GLOFPAY' in (autoload->psr-0) of (php-sdk/composer.json) file to your desired name and run "composer dump-autoload" command from SDK root

use GLOFPAY\Api\Amount;
use GLOFPAY\Api\Payer;
use GLOFPAY\Api\Payment;
use GLOFPAY\Api\RedirectUrls;
use GLOFPAY\Api\Transaction;

// Payer Object
$payer = new Payer();
$payer->setPaymentMethod('GLOFPAY'); // Preferably, your system name, example - GLOFPAY

// Amount Object
$amountIns = new Amount();
$amountIns->setTotal(4.99)->setCurrency('USD'); // Must give a valid currency code and must exist in merchant wallet list

// Transaction Object
$trans = new Transaction();
$trans->setAmount($amountIns);

// RedirectUrls Object
$urls = new RedirectUrls();
$urls->setSuccessUrl('http://your-merchant-domain.com/example-success.php') // Success URL - the merchant domain page, to redirect after successful payment
     ->setCancelUrl('http://your-merchant-domain.com/'); // Cancel URL - the merchant domain page, to redirect after cancellation of payment

// Payment Object
$payment = new Payment();
$payment->setCredentials([ // Client ID & Secret = Merchants->settings (gear icon)
    'client_id'     => 'place your client id here', // Must provide correct client ID of an express merchant
    'client_secret' => 'place your client secret here', // Must provide correct client secret of an express merchant
])
->setRedirectUrls($urls)
->setPayer($payer)
->setTransaction($trans);

try {
    $payment->create(); // Create payment
    header("Location: " . $payment->getApprovedUrl()); // Checkout URL
}
catch (\Exception $ex)
{
    print $ex;
    exit;
}
